#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <tcl.h>
#include <tk.h>

#include "namespace.h"
#include "agent.h"
#include "info_aqui.h"
#include "field.h"
#include "evolve.h"
#include "routine.h"
#include "utils.h"
#include "attribute.h"
#include "display.h"
#include "tcl_interface.h"
#include "tcl_attributes.h"
#include "tcl_agents.h"
#include "tcl_routines.h"
#include "tcl_fields.h"
#include "tcl_display.h"
#include "tcl_info_aqui.h"

extern long current_line;
extern long current_char;
extern char *input_data;
extern long input_ptr;
extern int input_string;
extern int error_encountered;
int yyparse(void);

int save_model(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
FILE *fout;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: save_model requires one argument",NULL);
	return TCL_ERROR;
	}
fout=fopen(argv[1],"w");
if(fout==NULL){
	Tcl_SetObjResult(interp,Tcl_NewIntObj(-1));
	return TCL_OK;
	}
dump_attributes(fout);	
dump_classes(fout);
dump_fields(fout);
dump_routines(fout);
fprintf(fout,"time %ld\n",get_time());
fclose(fout);
Tcl_SetObjResult(interp,Tcl_NewIntObj(0));
return TCL_OK;
}

void yyreset(void);
void reset_lex(void);

int yyparse_string(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: yyparse_string requires one argument",NULL);
	return TCL_ERROR;
	}
current_line=0;
current_char=0;
input_ptr=0;
input_data=argv[1];	
input_string=1;
error_encountered=0;
yyreset();
reset_lex();
yyparse();
if(error_encountered)
	Tcl_SetObjResult(interp,Tcl_NewIntObj(-1));
  else Tcl_SetObjResult(interp,Tcl_NewIntObj(0));
input_string=0;
error_encountered=0;  
return TCL_OK;
}


int reset_model(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
init_all();
return TCL_OK;
/*
The code above creates a memory leak - the program loses tens of K 
each time you press submit button. However the code below creates a sigfault.
The reason is that we have to be careful looking at pointers in conf_reader.y.
Also it is not clear how to free the data member of the ROUTINE structure.
And if we are going to create a memory leak anyway why don't do it elegantly ?

reset_routines();	
reset_fields();
reset_agentclasses();
reset_display();
return TCL_OK;
*/
}

int step_model(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
evolve_fields();
evolve_attributes();
tick();
return TCL_OK;
}


extern FILE *yyin;

int load_model(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
FILE *fin;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: save_model requires one argument",NULL);
	return TCL_ERROR;
	}
fin=fopen(argv[1],"r");
if(fin==NULL){
	Tcl_SetObjResult(interp,Tcl_NewIntObj(-1));
	return TCL_OK;
	}
reset_model(client_data,interp,argc,argv);	
yyin=fin;	
yyparse();
fclose(fin);
yyin=NULL;
Tcl_SetObjResult(interp,Tcl_NewIntObj(0));
return TCL_OK;
}

int model_time(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
Tcl_SetObjResult(interp,Tcl_NewIntObj(get_time()));
return TCL_OK;
}


int get_line_of_error(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
Tcl_SetObjResult(interp,Tcl_NewIntObj(current_line+1));
return TCL_OK;
}

int get_char_of_error(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
Tcl_SetObjResult(interp,Tcl_NewIntObj(current_char+1));
return TCL_OK;
}

char s[2000];

int get_message_of_error(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
sprintf(s,"Error encountered in line %ld, character %ld",current_line+1,current_char+1);
Tcl_AppendResult(interp,s,NULL);
return TCL_OK;
}

struct {
	char *name;
	Tcl_CmdProc *command;
	} commands[]={ 
		/* agentclass */
		{"agentclasses_num",agentclasses_num},
		{"agentclass_name",agentclass_name},
		{"find_agentclass",find_agentclass},
		/* attribute */
		{"num_attributes",num_attributes1},
		{"attribute_name",attribute_name},
		{"find_attribute",find_attribute},
		/* field */
		{"num_fields",num_fields1},
		{"field_name",field_name},
		{"find_field",find_field},
		{"field_x_dim",field_x_dim},
		{"field_y_dim",field_y_dim},
		{"seed_fields",seed_fields1},
		{"agent_attr_value",agent_attr_value},
		/* display */
		{"num_views",num_display1},
		{"view_name",display_name},
		{"find_view",find_display},
		{"view_shape",compute_type},
		{"view_color1",compute_color1},
		{"view_color2",compute_color2},
		{"view_color3",compute_color3},
/*		{"agentclass_attr_name",agentclass_attr_name},
		{"agentclass_remove_attr",agentclass_remove_attr},
		{"agentclass_add_attr",agentclass_add_attr},
		{"agentclass_attr_type",agentclass_attr_type}, */
		{"agentclass_attr_value",agentclass_attr_value},
		{"add_agentclass",add_agentclass1},
		{"save_model",save_model},
		{"load_model",load_model},
		{"reset_model",reset_model},
		{"step_model",step_model},
		/* parsing */
		{"yyparse_string",yyparse_string},
		{"get_line_of_error",get_line_of_error},
		{"get_char_of_error",get_char_of_error},
		{"get_message_of_error",get_message_of_error},
		/* statistics */
		{"num_stat",num_stat1},
		{"stat_name",stat_name},
		{"find_stat",find_stat},
		{"set_filename",set_filename1},
		{"stop_logging",stop_logging},
		{"log_statistics",log_statistics},
		{"num_values",num_values},
		{"get_value",get_value1},
		{"get_value_name",get_value_name1},
/*		{"agentclass_set_attr_type",agentclass_set_attr_type},
		{"agentclass_set_attr_name",agentclass_set_attr_name},
		{"agentclass_set_attr_value",agentclass_set_attr_value}, */
		{"model_time",model_time},
		{"num_routines",routines_num},
		{"routine_name",routine_name},
		{"routine_comment",routine_comment},
		{"routine_type",routine_type1},
		{"find_routine",find_routine},
		{NULL,NULL}
		};

void register_tcl_interface_functions(Tcl_Interp *interp)
{
int i;

for(i=0;commands[i].name!=NULL;i++)
	Tcl_CreateCommand(interp,commands[i].name,(Tcl_CmdProc *)commands[i].command,NULL,NULL);
	
}


void init_all(void)
{
init_agents();
init_info_aqui();
init_fields();
init_evolution_rules();
init_routines();
init_attributes();
init_display();
init_stat();
set_time(0);
}

